//*********************************************************************
// [COMIDAS sample program by COMIZOA Inc., Ltd]
//
// Subject : 
//   Motion Control, Unit speed Unit distance  
// Contents: 
//     ӵ Ÿ   ϰ ϴ°Ϳ  Դϴ.
//	   1cm ̵ϴµ ʿ ޽ 1000޽  Ÿ  cm, 
//   ӵ  cm/sec Ͽ Move ϴ Դϴ.
// Remarks:
//    α׷ COMI-LX501  Դϴ. 
//*********************************************************************
#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "comidaslx.h"

#define X_AXIS	0
#define Y_AXIS	1
#define Z_AXIS	2

void main()
{
	if(!COMILX_LoadDll()){
		printf("Error : ComidasLx.dll α׷ ε  ϴ.\n ƹ Ű  α׷ ˴ϴ.");
		getch();
		exit(-1); // Load Dll Failure
	}
	
	HANDLE hDevice = COMILX_LoadDevice(COMI_LX501, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Error : COMI-LX501 ̽ ε  ϴ.\n ƹ Ű  α׷ ˴ϴ.");
		exit(-1); // Load Device Failure
	}

	// Set 1000 pulses for unit distance				 	//
	//   1cm ̵ ʿ ޽ 1000޽		//
	// ϰ  Ÿ 1cm  ̴.				//
	COMILX_MC_SetUnitDistance(hDevice, 0, 1000); 
	// Set 1000 PPS for unit speed							//
	//   1cm ̵ ʿ ޽ 1000޽		//
	// ޽ ϰ  ӵ 1rpm  ̴.		//
	COMILX_MC_SetUnitSpeed(hDevice, 0, 1000);

	COMILX_MC_SetSpeed(hDevice, 0, 0, 50); // Set speed as 50 cm/sec/ //
	COMILX_MC_SetSpeedMode(hDevice, 0, 0); // Set constant speed mode //

	COMILX_MC_Move(hDevice, 0, 10); // 50 cm/sec ӵ 10cm ̵ . δ 10*1000=10000޽ µȴ.//
	
	COMILX_UnloadDevice(hDevice);
	COMILX_UnloadDll();
}
